/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric.events;

import com.aetherteam.aetherfabric.events.CancellableCallback;
import com.aetherteam.aetherfabric.events.ExperienceDropHelper;
import com.aetherteam.aetherfabric.events.FallHelper;
import java.util.Collection;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class LivingEntityEvents {
    public static final Event<Jumped> ON_JUMP = EventFactory.createArrayBacked(Jumped.class, invokers -> livingEntity -> {
        for (Jumped invoker : invokers) {
            invoker.onJump(livingEntity);
        }
    });
    public static final Event<ShieldBlock> ON_SHIELD_BLOCK = EventFactory.createArrayBacked(ShieldBlock.class, invokers -> (damageSource, callback) -> {
        for (ShieldBlock invoker : invokers) {
            invoker.onBlock(damageSource, callback);
        }
    });
    public static final Event<Fall> ON_FALL = EventFactory.createArrayBacked(Fall.class, invokers -> (entity, helper) -> {
        for (Fall invoker : invokers) {
            invoker.onFall(entity, helper);
        }
    });
    public static final Event<ExperienceDrop> ON_EXPERIENCE_DROP = EventFactory.createArrayBacked(ExperienceDrop.class, invokers -> (entity, attackingPlayer, helper) -> {
        for (ExperienceDrop invoker : invokers) {
            invoker.onExperienceDrop(entity, attackingPlayer, helper);
        }
    });
    public static final Event<ModifyDamage> ON_DAMAGE = EventFactory.createArrayBacked(ModifyDamage.class, invokers -> (entity, source, originalDamage, newDamage) -> {
        for (ModifyDamage invoker : invokers) {
            invoker.modifyDamage(entity, source, originalDamage, newDamage);
        }
    });
    public static final Event<OnStatusEffect> ON_EFFECT = EventFactory.createArrayBacked(OnStatusEffect.class, invokers -> (entity, instance, result) -> {
        for (OnStatusEffect invoker : invokers) {
            TriState newResult = invoker.onEffect(entity, instance, result);
            if (newResult == null) continue;
            result = newResult;
        }
        return result;
    });

    public static interface OnStatusEffect {
        @Nullable
        public TriState onEffect(class_1309 var1, class_1293 var2, TriState var3);
    }

    @FunctionalInterface
    public static interface ModifyDamage {
        public void modifyDamage(class_1309 var1, class_1282 var2, float var3, MutableFloat var4);
    }

    public static interface ExperienceDrop {
        public void onExperienceDrop(class_1309 var1, @Nullable class_1657 var2, ExperienceDropHelper var3);
    }

    public static interface Fall {
        public void onFall(class_1309 var1, FallHelper var2);
    }

    public static interface ShieldBlock {
        public void onBlock(class_1282 var1, CancellableCallback var2);
    }

    public static interface Jumped {
        public void onJump(class_1309 var1);
    }

    public static interface OnDrops {
        public void onDrops(class_1309 var1, class_1282 var2, Collection<class_1542> var3, boolean var4, CancellableCallback var5);
    }
}

